export const ChatIcon: React.FC<React.SVGAttributes<{}>> = (props) => (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" {...props}>
    <path
      fill="currentColor"
      d="M18.106 16.901a.469.469 0 0 1-.58.58l-2.333-.666a5.628 5.628 0 0 1-8-3.074 5.625 5.625 0 0 0 5.614-7.482 5.625 5.625 0 0 1 4.631 8.31l.668 2.332Z"
      opacity={0.2}
    />
    <path
      fill="currentColor"
      d="M18.109 14.635a6.25 6.25 0 0 0-4.861-8.964A6.25 6.25 0 1 0 1.89 10.885l-.598 2.096a1.094 1.094 0 0 0 1.352 1.351l2.095-.598c.632.31 1.312.512 2.012.596a6.25 6.25 0 0 0 8.508 3.154l2.095.598a1.094 1.094 0 0 0 1.352-1.351l-.598-2.096ZM4.807 12.44a.64.64 0 0 0-.172.024l-2.063.59.59-2.064a.625.625 0 0 0-.053-.469 4.996 4.996 0 1 1 1.997 1.998.62.62 0 0 0-.299-.079Zm12.031 2.3.59 2.063-2.063-.59a.625.625 0 0 0-.469.054 5.005 5.005 0 0 1-6.744-1.925 6.245 6.245 0 0 0 5.496-7.333 5 5 0 0 1 3.243 7.26.624.624 0 0 0-.053.471Z"
    />
  </svg>
);

export const ChatOwnerIcon: React.FC<React.SVGAttributes<{}>> = (props) => {
  return (
    <svg
      width="1em"
      height="1em"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        opacity={0.2}
        d="M17.5 7.5v10L14.408 15H6.875a.625.625 0 01-.625-.625V11.25h6.875a.624.624 0 00.625-.625v-3.75h3.125a.625.625 0 01.625.625z"
        fill="currentColor"
      />
      <path
        d="M16.875 6.25h-2.5v-2.5a1.25 1.25 0 00-1.25-1.25h-10a1.25 1.25 0 00-1.25 1.25v10a.625.625 0 001.016.486l2.734-2.205v2.344a1.25 1.25 0 001.25 1.25h7.312l2.922 2.36a.625.625 0 00.833-.043.624.624 0 00.183-.442v-10a1.25 1.25 0 00-1.25-1.25zM5.199 10.764l-2.074 1.677V3.75h10v6.875H5.592a.625.625 0 00-.393.14zm11.676 5.427l-2.074-1.677a.625.625 0 00-.39-.139H6.874v-2.5h6.25a1.25 1.25 0 001.25-1.25V7.5h2.5v8.691z"
        fill="currentColor"
      />
    </svg>
  );
}